/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.core.includepath;

import com.aptana.editor.php.internal.builder.IPHPLibrary;
import com.aptana.editor.php.internal.builder.LibraryManager;
import com.aptana.editor.php.internal.builder.preferences.DependenciesManager;
import com.aptana.editor.php.internal.builder.preferences.ProjectDependencies;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public final class PHPIncludePathUtils {
    public static List<String> getInterpreterIncludePath(IProject project) {
        ProjectDependencies dependencies = DependenciesManager.getDependencies((IProject)project);
        if (dependencies == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (File directory : dependencies.getDirectories()) {
            result.add(directory.getAbsolutePath());
        }
        IPHPLibrary[] allLibraries = LibraryManager.getInstance().getAllLibraries();
        HashSet<IPHPLibrary> usedLibraries = new HashSet<IPHPLibrary>(Arrays.asList(allLibraries));
        if (dependencies.isUsesCustomLibs()) {
            List notUsedLibrariesIds = dependencies.getNotUsedLibrariesIds();
            for (String s : notUsedLibrariesIds) {
                IPHPLibrary library = LibraryManager.getInstance().getLibrary(s);
                if (library == null) continue;
                usedLibraries.remove(library);
            }
        } else {
            IPHPLibrary[] iPHPLibraryArray = allLibraries;
            int n = allLibraries.length;
            int n2 = 0;
            while (n2 < n) {
                IPHPLibrary l = iPHPLibraryArray[n2];
                if (!l.isTurnedOn()) {
                    usedLibraries.remove(l);
                }
                ++n2;
            }
        }
        for (IPHPLibrary l : usedLibraries) {
            for (String s : l.getDirectories()) {
                File fl = new File(s);
                result.add(fl.getAbsolutePath());
            }
        }
        for (IResource workspaceResource : dependencies.getWorkspaceResources()) {
            IPath resourcePath = workspaceResource.getLocation();
            result.add(resourcePath.toOSString());
        }
        return result;
    }

    private PHPIncludePathUtils() {
    }
}

